<!--
BOSCH Security Systems (Grassbrunn)
Project: Magic.Panel
Author: Maria Lux
Created: 09-07-2013
$Revision: 1.1 $ 
Last locked:   $Date: 2017/04/24 09:34:46BST $
Last change by $Author: Sreekantha Sreenivasalu (REE8KOR) $
History: 
$Log: References/ToolsSetup/conv-2-14-0-to-2-14-0.xsl  $
Revision 1.1 2017/04/24 09:34:46BST Sreekantha Sreenivasalu (REE8KOR) 
Initial revision
Member added to project f:/MKS_Repository/Fire/RPS/FSP-5000-RPS/Sources/BuildAutomation/BuildPrerequisite/BuildPrerequisite.pj
Revision 1.2 2015/11/20 13:00:36CET Maria Lux (lux2ot) 
updated after correction of defect 322319
Revision 1.2 2015/11/20 08:33:46CET Maria Lux (lux2ot) 
conversion of passwords and remote access operators corrected
Revision 1.1 2015/05/21 15:00:52CEST Maria Lux (lux2ot) 
Initial revision
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cfg="." xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:user="http://bosch.com" xmlns:user2="http://user2.bosch.com">
  <xsl:include href="hashFunction.xsl"/>
  <xsl:output method="xml" encoding="UTF-8" indent="yes"/>
  <!--##############  BEGIN Namspace cfg   ####################-->
  <cfg:Stylesheet mode="TRANSFORM" version="$Revision: 1.1 $" versionscope="ALL_FILES" backup="true" backupdir="cebackup"/>
  <cfg:Description lang="DE">Konvertiere Konfiguration mit Schemaversionen kleiner V2.14.0 zu Schema V2.14.0, Parameter newversion=2.14.0</cfg:Description>
  <cfg:Description lang="EN">Convert pre V2.14.0 configurations to  V2.14.0 parameter newversion= V2.14.0</cfg:Description>
  <!--##############  END Namspace cfg   ####################-->
  <xsl:include href="create-net.xsl"/>
  <xsl:include href="counter-2-x.xsl"/>
  <!--****************  SPECIAL PART modifications to certain nodes ***********************-->
  <!-- ################################## NEW in VERSION 2.9.0 ######################## -->
  <xsl:template match="CONFIG_NETWORK">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
    <xsl:element name="{name()}">
      <xsl:for-each select="*">
        <xsl:choose>
          <xsl:when test="name() = 'SUPPORT_INFO'">
            <xsl:apply-templates select="."/>
			<!-- the variables "temp1" and "temp2" will not be used; they are only needed to call the functions Set...Inserted-->
			 <xsl:variable name="temp1" select="user:SetCloudInserted(string('0'))"/>
			 <xsl:variable name="temp2" select="user:SetP2PInserted(string('0'))"/>
			 <xsl:choose>
				 <xsl:when test="user:IsVersionGreaterOrEqual ($ConvertedFrom, '2.13.2')">
					 <!-- the new structure already exists =>no need to do anything -->
				 </xsl:when>
					<xsl:when test="user:IsVersionGreaterOrEqual ($ConvertedFrom, '2.13.0')">
						 <xsl:if test="../CLOUD_DATA = true() and ../CLOUD_DATA/ipAddress != ''" >
								<!-- the variable "temp" will not be used; it is only needed to call the function SetCloudInserted-->
								<xsl:variable name="temp" select="user:SetCloudInserted(string('1'))"/>
								<!-- the CLOUD_DATA have to be moved one step lower -->
								<xsl:element name="REMOTE_SERVICES_NETWORK_DATA">
									<xsl:element name="CLOUD_DATA">
										<xsl:element name="ipAddress"><xsl:value-of select="../CLOUD_DATA/ipAddress"/></xsl:element>
										<xsl:element name="portNumber"><xsl:value-of select="../CLOUD_DATA/portNumber"/></xsl:element>
										<xsl:element name="siteName"><xsl:value-of select="../CLOUD_DATA/siteName"/></xsl:element>
										<xsl:element name="crl">172.31.31.1</xsl:element>
									</xsl:element>
								</xsl:element>
						 </xsl:if>
					</xsl:when>
					 <xsl:when test="user:IsVersionGreaterOrEqual ($ConvertedFrom, '2.13.0')=false()">
						<xsl:if test="../CM_SERVER = true() and ../CM_SERVER/ipAddress != '' and user:GetP2PInserted()='0'">
							<!-- the variable "temp" will not be used; it is only needed to call the function SetP2PInserted-->
							<xsl:call-template name="AddP2PData_CM">
								<xsl:with-param name="cmNetworkId"><xsl:value-of select="../CM_SERVER/cmNetworkId"/></xsl:with-param>
								<xsl:with-param name="ipAddress"><xsl:value-of select="../CM_SERVER/ipAddress"/></xsl:with-param>
								<xsl:with-param name="portNumber"><xsl:value-of select="../CM_SERVER/portNumber"/></xsl:with-param>
							</xsl:call-template>
						  <xsl:variable name="temp" select="user:SetP2PInserted(string('1'))"/>
						</xsl:if>
					 </xsl:when>
				</xsl:choose>
				<xsl:if test="user:IsVersionLess ($ConvertedFrom, '2.13.2')">
					<xsl:if test="user:GetCloudInserted()='0' and user:GetP2PInserted()='0'">
						 <xsl:if test="//TRANSFER[isTeleservice='ST_YES' and useIPTeleservice='ST_YES']">
						 <!-- at least one panel uses peer-to-peer teleservice -->
							  <xsl:call-template name="AddP2PData"/>
							  <xsl:variable name="temp" select="user:SetP2PInserted(string('1'))"/>
						 </xsl:if>
					</xsl:if>
				</xsl:if>
            <!-- correct level of (remote) network operators; the highest level wins if there are different levels assigned -->
			<xsl:if test="user:IsVersionLess ($ConvertedFrom, '2.13.2')">
				<xsl:choose>
					<xsl:when test="//OPERATOR[id=10001 and level='4'] = true()">
					<!-- at least one operator with level 4 existing => highest level is 4 -->
						<!-- the variable "temp" will not be used; it is only needed to call the function SetHighestRemoteOperatorLevel-->
						<xsl:variable name="temp" select="user:SetHighestRemoteOperatorLevel(string('4'))"/>
					</xsl:when>
					<xsl:when test="//OPERATOR[id=10001 and level='3'] = true()">
					<!-- at least one operator with level 3 existing => highest level is 3 -->
						<!-- the variable "temp" will not be used; it is only needed to call the function SetHighestRemoteOperatorLevel-->
						<xsl:variable name="temp" select="user:SetHighestRemoteOperatorLevel(string('3'))"/>
					</xsl:when>
					<xsl:when test="//OPERATOR[id=10001 and level='2'] = true()">
					<!-- at least one operator with level 2 existing => highest level is 2 -->
						<!-- the variable "temp" will not be used; it is only needed to call the function SetHighestRemoteOperatorLevel-->
						<xsl:variable name="temp" select="user:SetHighestRemoteOperatorLevel(string('2'))"/>
					</xsl:when>
					<xsl:when test="//OPERATOR[id=10001 and level='1'] = true()">
					<!-- at least one operator with level 1 existing => highest level is 1 -->
						<!-- the variable "temp" will not be used; it is only needed to call the function SetHighestRemoteOperatorLevel-->
						<xsl:variable name="temp" select="user:SetHighestRemoteOperatorLevel(string('1'))"/>
					</xsl:when>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="$ConvertedFrom='2.14.0'">
				<!-- get the highest counter number -->
				<xsl:for-each select="//COUNTER">
						<!-- the variable "temp" will not be used; it is only needed to call the function SetHighestCounter -->
						<xsl:variable name="temp" select="user:SetHighestCounter(string(./siNumber))"/>
				</xsl:for-each>
			</xsl:if>
			<xsl:if test="$ConvertedFrom='2.14.0'">
				<xsl:for-each select="//IO2_S20_MODULE/S20/cityTieAddress">
					<xsl:if test="user:GetPart(string(./text()), 0) = 'MP_SI_CITYTIE'">
						<xsl:variable name="ueeNumber" select="user:GetPart(string(./text()), 1)"/>
						<xsl:if test="user:HasUeEToBeModified($ueeNumber) = false()">
							<xsl:variable name="temp" select="user:AddUeE(string($ueeNumber))"/>
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each select="//IO_S20_MODULE/S20/cityTieAddress">
					<xsl:if test="user:GetPart(string(./text()), 0) = 'MP_SI_CITYTIE'">
						<xsl:variable name="ueeNumber" select="user:GetPart(string(./text()), 1)"/>
						<xsl:if test="user:HasUeEToBeModified($ueeNumber) = false()"> 
							<xsl:variable name="temp" select="user:AddUeE(string($ueeNumber))"/>
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="."/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- ################################## END VERSION 2.9.0 ######################## -->
  <!-- RULE and RULE_STATE: note must be added -->
  <xsl:template match="RULE | RULE_STATE">
    <xsl:element name="{name()}">
      <xsl:if test="note = false()">
        <xsl:element name="note"/>
      </xsl:if>
      <xsl:for-each select="*">
        <xsl:apply-templates select="."/>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- make existing RULE_STATE sequence to one RULE_STATE_BLOCK -->
  <xsl:template match="RULE_STATE">
    <xsl:choose>
      <xsl:when test="parent::RULE_STATE_BLOCK = false()">
        <xsl:if test="preceding-sibling::RULE_STATE = false()">
          <xsl:element name="RULE_STATE_BLOCK">
            <xsl:for-each select="../RULE_STATE">
              <xsl:element name="RULE_STATE">
                <xsl:apply-templates/>
              </xsl:element>
            </xsl:for-each>
          </xsl:element>
        </xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <xsl:for-each select=".">
          <xsl:element name="RULE_STATE">
            <xsl:apply-templates/>
          </xsl:element>
        </xsl:for-each>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template match="FAT_LEDORBUTTON">
  <xsl:choose>
			<xsl:when test="subNumber='100'">
				<xsl:element name="FAT_LEDORBUTTON">
					<xsl:element name="subNumber">100</xsl:element>
					<xsl:variable name="counterX" select="descendant::*/CONDITION_COUNTER/conditionNumber"/>
					<xsl:call-template name="CreateCounterRule">
						<xsl:with-param name="counter" select="$counterX"/>
					</xsl:call-template>
				</xsl:element>
			</xsl:when>
			<xsl:when test="subNumber='101'">
				<xsl:element name="FAT_LEDORBUTTON">
					<xsl:element name="subNumber">101</xsl:element>
					<xsl:variable name="counterX" select="descendant::*/CONDITION_COUNTER/conditionNumber"/>
					<xsl:call-template name="CreateCounterRule">
						<xsl:with-param name="counter" select="$counterX"/>
					</xsl:call-template>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:element name="FAT_LEDORBUTTON">
					<xsl:apply-templates select="*"/>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
  </xsl:template>
  
  <xsl:template match="COUNTER">
	  <xsl:choose>
				<xsl:when test="subject='MP_SI_FBF'">
					<xsl:element name="COUNTER">
						<xsl:element name="siNumber"><xsl:value-of select="siNumber"/></xsl:element>
						<xsl:element name="label"></xsl:element>
						<xsl:element name="cstate">MP_ET_ON</xsl:element>
						<xsl:element name="condition">EQ</xsl:element>
						<xsl:element name="subject">MP_SI_FAT</xsl:element>
						<xsl:element name="subjectNumber"><xsl:value-of select="subjectNumber"/></xsl:element>
						<xsl:element name="subjectSubNumber"><xsl:value-of select="subjectSubNumber"/></xsl:element>
						<xsl:element name="isRemote"><xsl:value-of select="isRemote"/></xsl:element>
					</xsl:element>
				</xsl:when>
				<xsl:otherwise>
					<xsl:element name="COUNTER">
						<xsl:apply-templates select="*"/>
					</xsl:element>
				</xsl:otherwise>
			</xsl:choose>
  </xsl:template>
  <xsl:template name="CreateCounterRule">
  <xsl:param name="counter"/>
    <!--
<RULE_STATE_BLOCK rpsDisplayName="Block of State-Dependent Rules">
<RULE_STATE rpsDisplayName="State Dependent Rule">
<note></note>
<CONDITION_COUNTER rpsDisplayName="Condition - Counter -1 - Counter.60012 - Greater than/0 - On: Steady">
<conditionNumber>60012</conditionNumber>
<threshold>0</threshold>
<comparator>GT</comparator>
</CONDITION_COUNTER>
<FAT_ACTION rpsDisplayName="Activation">
<action>MP_ACT_SWITCHON</action>
<duration>0</duration>
</FAT_ACTION>
</RULE_STATE>
<RULE_STATE rpsDisplayName="Default ( Else condition)">
<note></note>
<FAT_ACTION rpsDisplayName="Activation - Off">
<action>MP_ACT_SWITCHOFF</action>
<duration>0</duration>
</FAT_ACTION>
</RULE_STATE>
</RULE_STATE_BLOCK>
-->
	<xsl:element name="RULE_STATE_BLOCK">
		<xsl:element name="RULE_STATE">
			<xsl:element name="note"></xsl:element>
			<xsl:element name="CONDITION_COUNTER">
				<xsl:element name="conditionNumber"><xsl:value-of select="$counter"/></xsl:element>
				<xsl:element name="threshold">0</xsl:element>
				<xsl:element name="comparator">GT</xsl:element>
			</xsl:element>
			<xsl:element name="FAT_ACTION">
				<xsl:element name="action">MP_ACT_SWITCHON</xsl:element>
				<xsl:element name="duration">0</xsl:element>
			</xsl:element>
		</xsl:element>
		<xsl:element name="RULE_STATE">
			<xsl:element name="note"></xsl:element>
			<xsl:element name="FAT_ACTION">
				<xsl:element name="action">MP_ACT_SWITCHOFF</xsl:element>
				<xsl:element name="duration">0</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:element>
  </xsl:template>
  <xsl:template name="Create_RemoteServicesAll">
	  <xsl:param name="useTeleserviceVal"/>
	  <xsl:param name="isAutoAnswerEnabledVal"/>
	  <xsl:param name="useCMVal"/>
	  <xsl:element name="REMOTE_SERVICES">
			<!-- the variable "temp" will not be used; it is only needed to call the function SetRemoteServicesInserted-->
			<xsl:variable name="temp" select="user:SetRemoteServicesInserted(string('true'))"/>
		  <xsl:call-template name="CreateTeleservice">
				<xsl:with-param name="useTeleserviceVal"><xsl:value-of select="$useTeleserviceVal"/></xsl:with-param>
				<xsl:with-param name="isAutoAnswerEnabledVal"><xsl:value-of select="$isAutoAnswerEnabledVal"/></xsl:with-param>
		  </xsl:call-template>
		  <xsl:element name="REMOTE_MONITORING">
			  <xsl:element name="isEnabled"><xsl:value-of select="$useCMVal"/></xsl:element>
		  </xsl:element>
	  </xsl:element>
  </xsl:template>
  <xsl:template name="CreateTeleservice">
	  <xsl:param name="useTeleserviceVal"/>
	  <xsl:param name="isAutoAnswerEnabledVal"/>
	  <xsl:element name="IP_TELESERVICE">
		<xsl:element name="isAutoAnswerEnabled"><xsl:value-of select="$isAutoAnswerEnabledVal"/></xsl:element>
		<xsl:element name="isEnabled"><xsl:value-of select="$useTeleserviceVal"/></xsl:element>
	  </xsl:element>
  </xsl:template>
  <!-- -->
  <msxsl:script language="javascript" implements-prefix="user">
	<![CDATA[
   function IsServer(value)
   {
     if(value == "OPC_SERVER" || value == "MCP_SERVER" || value == "FSI_SERVER")
     {
       return true;
     }
     return false;
   }
   function IsRemoteKeypad(value)
   {
     if(value == "FPA5000_RK" || value == "FPA5000_RK-C")
     {
       return true;
     }
     return false;
   }
   function IsPanel(value)
   {
     if(value == "FPA5000" || value == "FPA5000-C" || value == "FPA1200_EN" || value == "FPA1200_EN-C")
     {
       return true;
     }
     return false;
   }
   function IsHW_C(value)
   {
     if(value == "FPA5000-C" || value == "FPA5000_RK-C" || value == "FPA1200_EN-C")
     {
       return true;
     }
     return false;
   }
   var maxVal = 0;
   function SetMax(value)
   {
     if(value > maxVal)
     {
       maxVal = value;
     }
     return true;
   }
   function ResetMax()
   {
     maxVal = 0;
     return true;
   }
   function GetMax()
   {
     return maxVal;
   }
   var currentAssignedCMServerVal = "0";
   function SetCurrentAssignedCMServer(value)
   {
	   currentAssignedCMServerVal = value;
	   return currentAssignedCMServerVal;
   }
   function GetCurrentAssignedCMServer()
   {
	   return currentAssignedCMServerVal;
   }
   var remoteServicesInserted = "0";
   function SetRemoteServicesInserted(value)
   {
	   remoteServicesInserted = value;
	   return remoteServicesInserted;
   }
   function GetRemoteServicesInserted()
   {
	   return remoteServicesInserted;
   }

   var highestRemoteOperatorLevel = "4";
   function SetHighestRemoteOperatorLevel(value)
   {
	   highestRemoteOperatorLevel = value;
	   return highestRemoteOperatorLevel;
   }
   function GetHighestRemoteOperatorLevel()
   {
	   return highestRemoteOperatorLevel;
   }

   var highestCounterNumber = "60000";
   function SetHighestCounter(value)
   {
	   if (Number(value) > Number(highestCounterNumber))
	   {
		   highestCounterNumber = value;
	   }
	   return highestCounterNumber;
   }
   function GeHighestCounter()
   {
	   return highestCounterNumber;
   }
   function IncHighestCounter()
   {
	   var temp = Number(highestCounterNumber);
	   temp = temp + 1;
	   highestCounterNumber = temp.toString();
	   return highestCounterNumber;
   }
	function GetPartNumber(stringToSplit, part)
	{
		var partNumber = 0;
		var tokenX = stringToSplit.split(".");
		var partNumber = Number(tokenX[part]);
		return partNumber;
	}
	function GetPart(stringToSplit, part)
	{
		var partNumber = 0;
		var tokenX = stringToSplit.split(".");
		return partNumber;
	}
   var counterInserted = "0";
   function SetCounterInserted(value)
   {
	   counterInserted = value;
	   return counterInserted;
   }
   function GetCounterInserted()
   {
	   return counterInserted;
   }
   var bypassCounterList = [];
   function AddBypassCounter(value)
   {
	   bypassCounterList.push(value);
	   return value;
   }
   function GetBypassCounter(index)
   {
	   var retValue = "";
	   if (Number(index) < bypassCounterList.length)
	   {
		   retValue = bypassCounterList[Number(index)];
	   }
	   return retValue;
   }
   function GetBypassCount()
   {
	   return bypassCounterList.length;
   }
   var bypassCounterListIndex = -1;
   function GetNextBypassCounter()
   {
	   var retValue = "";
	   bypassCounterListIndex = bypassCounterListIndex + 1;
	   if (bypassCounterListIndex < bypassCounterList.length)
	   {
		   retValue = bypassCounterList[Number(bypassCounterListIndex)];
	   }
	   return retValue;
   }
   function GetBypassCounters()
   {
	   return bypassCounterList;
   }
   function ResetBypassCounterIndex()
   {
	   bypassCounterListIndex = -1;
	   return bypassCounterListIndex;
   }
   
   var testCounterList = [];
   function AddTestCounter(value)
   {
	   testCounterList.push(value);
	   return value;
   }
   function GetTestCounter(index)
   {
	   var retValue = "";
	   if (Number(index) < testCounterList.length)
	   {
		   retValue = testCounterList[Number(index)];
	   }
	   return retValue;
   }
   function GetTestCounters()
   {
	   return testCounterList;
   }
   function GetTestCount()
   {
	   return testCounterList.length;
   }
   var testCounterListIndex = -1;
   function GetNextTestCounter()
   {
	   var retValue = "";
	   testCounterListIndex = testCounterListIndex + 1;
	   if (testCounterListIndex < testCounterList.length)
	   {
		   retValue = testCounterList[Number(testCounterListIndex)];
	   }
	   return retValue;
   }
   function ResetTestCounterIndex()
   {
	   testCounterListIndex = -1;
	   return testCounterListIndex;
   }
   var sumBypassCounter = 0;
   function SetSumBypassCounter(value)
   {
	   sumBypassCounter =Number( value);
	   return sumBypassCounter;
   }
   function GetSumBypassCounter()
   {
	   return sumBypassCounter;
   }
   var sumTestCounter = 0;
   function SetSumTestCounter(value)
   {
	   sumTestCounter = Number(value);
	   return sumTestCounter;
   }
   function GetSumTestCounter()
   {
	   return sumTestCounter;
   }
   var ueeList = [];
   function AddUeE(value)
   {
	   ueeList.push(value);
   }
   function HasUeEToBeModified(value)
   {
	   var retValue = false;
	   var i = 0;
	   while ((retValue == false) && (i < ueeList.length))
	   {
		   if (ueeList[i] == value)
		   {
			   retValue = true;
		   }
		   i++;
	   }
	   return retValue;
   }
   var bypassUeECounterList = [];
   function AddBypassUeECounter(value)
   {
	   bypassUeECounterList.push(value);
	   return value;
   }
   function GetBypassUeECounter(index)
   {
	   var retValue = "";
	   if (Number(index) < bypassUeECounterList.length)
	   {
		   retValue = bypassUeECounterList[Number(index)];
	   }
	   return retValue;
   }
   function GetBypassUeECount()
   {
	   return bypassUeECounterList.length;
   }
   var activatedUeECounterList = [];
   function AddActivatedUeECounter(value)
   {
	    activatedUeECounterList.push(value);
	   return value;
   }
   function GetActivatedUeECounter(index)
   {
	   var retValue = "";
	   if (Number(index) <  activatedUeECounterList.length)
	   {
		   retValue =  activatedUeECounterList[Number(index)];
	   }
	   return retValue;
   }
   function GetActivatedUeECount()
   {
	   return activatedUeECounterList.length;
   }
   var sumUeEBypassCounter = 0;
   function SetSumUeEBypassCounter(value)
   {
	   sumUeEBypassCounter =Number( value);
	   return sumUeEBypassCounter;
   }
   function GetSumUeEBypassCounter()
   {
	   return sumUeEBypassCounter;
   }
   var sumUeEActivatedCounter = 0;
   function SetSumUeEActivatedCounter(value)
   {
	   sumUeEActivatedCounter = Number(value);
	   return sumUeEActivatedCounter;
   }
   function GetSumUeEActivatedCounter()
   {
	   return sumUeEActivatedCounter;
   }
]]>
    </msxsl:script>
</xsl:stylesheet>
